#if !defined(AFX_DEMODATA_H__0A000FE0_69E1_11D2_B49D_EA9544C44F03__INCLUDED_)
#define AFX_DEMODATA_H__0A000FE0_69E1_11D2_B49D_EA9544C44F03__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

typedef struct demodata_t 
{
	unsigned int		id;
	int					time;
	bool				used;
	int					type;
	char*				message;
	int*				vp_int;
	float*				vp_float;
	unsigned int		frame;
	int					killer; // set if (type == kill), else -1
	int					victim; // set if (type == kill), else -1
	int					weapon; // set if (type == kill), else -1
	demodata_t*			next;
	demodata_t*			next_of_type;
} demodata_t;

typedef struct origin_t
{
	unsigned int		frame;
	int					entity;
	float				origin[3];
	origin_t*			next;
} origin_t;

class demodata  
{
	int					time;
	int					oldframe;
	bool				changed;
	demodata_t*			first;
	demodata_t*			last;
	demodata_t*			current;
	origin_t*			first_origin;
	origin_t*			last_origin;
	origin_t*			current_origin;
public:
	demodata_t* get_last();
	demodata			();
	virtual ~demodata	();
	void				add (unsigned int frame, int type, ...);
	demodata_t*			get_first ();
	demodata_t*			get_first_of_type (int type);
	void				build_next_of_type_list ();
};

#endif // !defined(AFX_DEMODATA_H__0A000FE0_69E1_11D2_B49D_EA9544C44F03__INCLUDED_)
